#############################
#                           #
#        LECTURE TEN        #
#                           #
#############################


############################## PART 1 #############################


## Montgomery, Example 6.1, p.245
# Etch rate for a plasma etching tool
# y is etch rate, A is gap between electrodes, B is gas flow rate,
# C is power
# A, B and C all have two levels - 2^3 design
plasma = read.table("plasma.txt",header=TRUE)
plasma
# In the sequel, we neglect "rep" as a factor
# Short notation - note that all terms are numeric, not factors
y = plasma$y; A = plasma$A; B = plasma$B; C = plasma$C
# Interaction terms by multiplication
A*B
A*B*C
(A*C)*(B*C)  # Note that C^2=I
# Some effects
effA = 2*mean(A*y); effA
effABC = 2*mean(A*B*C*y); effABC
# Some contrasts and sum of squares
ctrA = sum(A*y); ctrA
SSA = ctrA^2/16; SSA
ctrABC = sum(A*B*C*y); ctrABC
SSABC = ctrABC^2/16; SSABC
# The regression approach
reg1 = lm(y ~ A*B*C)
# Because of the orthogonal (balanced) design, summary and anova
# give the same p-values
summary(reg1)
anova(reg1)
# The coefficients are half the effects, e.g.
effA/2  # conforms with
coef(reg1)
# Backwards elimination. By the hierarchy principle, A:B:C out first
anova(lm(y ~ (A + B + C)^2))
# Then B:C out
anova(lm(y ~ A + B + C + A:B + A:C))
# Then A:B out
anova(lm(y ~ A + B + C + A:C))
# We see that all effects including B (= flow rate) can be excluded
reg2 = lm(y ~ A + C + A:C); anova(reg2)
# This is the final model. We check it
plot(fitted(reg2), resid(reg2)); abline(h=0, lty=2)
# We get the regression coefficients
coef(reg1)
c = coef(reg2); c
# These are the surviving coefficients from the first model
# (surviving by orthogonality, otherwise they would be modified):
# Now I try to make the plots on Figure 6.7, p.248
# Y below is a grid matrix with values on the response surface
x1 = x2 = seq(-1, 1, 0.1)
one = rep(1, length(x1))
Y = c[1] + c[2]*outer(x1, one) + c[3]*outer(one, x2) + c[4]*outer(x1, x2)
# Perspective plot (Fig 6.7(a), p.248)
persp(x1, x2, Y)
persp(x1, x2, Y, theta=-35, phi=10, r=10)
# Contour plot (Fig 6.7(b), p.248)
contour(x1, x2, Y, labcex=1)
# Easier to see the slight curvature than at the perspective plot.
rm(list=ls())

# Montgomery, Example 6.2, p.257
# Filtration rate.  Notice all the effects in Table 6.11
# y filtration rate, A temperature, B pressure,
# C concentration of formaldehyde, D stirring rate
# All have two levels - a 2^4 design
filtration = read.table("filtration.txt",header=TRUE)
filtration
y = filtration$y; A = filtration$A; B = filtration$B; C = filtration$C; D = filtration$D
reg1 = lm(y ~ A*B*C*D)
aov(reg1)
# There are no degrees of freedom left for Error.
coef(reg1)
# Calculate the effects (see Table 6.12)
eff = 2 * coef(reg1)[-1]; eff
# Make a Normal probability plot (Figure 6.11, axes reversed)
qqnorm(eff)
identify(qnorm(ppoints(15)), sort(eff), names(sort(eff)))
# Click left mouse button to identify, ESC to stop.
# The effects A, AC, AD, D and C protrudes.
# Assume that the others can be considered error.
# Note that if any interaction involving B were significant, B itself
# would also be included, even if it were not outlying.
reg2 = lm(y ~ A*(C + D))
anova(reg2)
plot(fitted(reg2), resid(reg2)); abline(h=0, lty=2)
interaction.plot(A, C, y)
interaction.plot(A, D, y)
interaction.plot(C, D, y)  # Here no indication of interaction
# A contour plot. See Figure 6.14(a), p.262.  Notice that x4=1.
# Hence some coefficients are added, see p.262.
c = coef(reg2); c
x1 = x3 = seq(-1, 1, 0.1)
one = rep(1, length(x1))
Y = (c[1] + c[4]) + (c[2] + c[6])*outer(x1, one) + 
  c[3]*outer(one, x3) + c[5]*outer(x1, x3)
contour(x1, x3, Y, levels=seq(50, 90, 10), labcex=1)
# Cleaning up
rm(list=ls())


########################### EXERCISE ############################


# Exercise 1
# Problem 6.28 (p.298)
# If you finish this, try to solve 6.29


############################ PART 2 #############################

## Fractional designs - sorry, I have not had time to do an example

## Nested designs
# We use the GAD package to deal with fixed and random factors
library(GAD)
# Montgomery, Example 14.1, p.607
# y = measurements of purity of batches of material
# A = different supplier (3) - a fixed factor
# B = different batches from each supplier (4) - a random factor
ex141 = read.table("ex141.txt")
ex141
ex141$A = as.fixed(ex141$A); ex141$B = as.random(ex141$B)
obj = aov(y ~ A + B%in%A, data=ex141)
M = gad(obj); M
# We compare with the acknowledged faulty Table 14.5, p.608:
gad(aov(y ~ A*B, data=ex141))
# We see that B and A:B are merged in the correct version (SS adds up).
# Now the variance components (use Table 14.1, p.606):
MSE = M[3,3]
MSB.A = M[2,3]
var.E = MSE; var.E  # Check on p.612
var.B = (MSB.A - MSE)/3; var.B
# Assume that A (= supplier) has no influence
# The 12 batches can be extracted in a smart way:
obj2 = aov(y ~ A:B, data=ex141)
N = anova(obj2); N
var.B.new = (N[1,3] - N[2,3])/3; var.B.new  # Almost unchanged
rm(list=ls())

########################### EXERCISE ############################


# Exercise 2
# Problem 14.3 (p. 637)
