##############################
#                            #
#        LECTURE NINE        #
#                            #
##############################


############################## PART 1 ###############################


## Random effects.  Montgomery, Example 13.1, p.575.
ex131 = read.table("ex131.txt")
ex131
names(ex131)
# We make random factors
library(GAD)
ex131$oper = as.random(ex131$oper); ex131$part = as.random(ex131$part)
# Remember that oper*part expands to oper + part + oper:part
obj = aov(y ~ part*oper, data=ex131)
M = gad(obj); M
# By the way, here we get the wrong p-values if we use fixed effects
gad(aov(y ~ as.fixed(part)*as.fixed(oper), data=ex131))
# Extracting values for the variance components
MSA = M[1,3]; MSA
MSB = M[2,3]; MSB
MSAB = M[3,3]; MSAB
MSE = M[4,3]; MSE
# Now we can get the variance components on p.576:
a = 20; b = 3; n = 2
var.A = (MSA - MSAB)/(b*n); var.A
var.B = (MSB - MSAB)/(a*n); var.B
var.AB = (MSAB - MSE)/n; var.AB  # Negative!!
var.E = MSE; var.E
var.A + var.B + var.AB + var.E
# Gives var.y = 11.14649.
# Now assuming that var.AB vanishes (additive model):
obj2 = aov(y ~ part + oper, data=ex131)
gad(obj2)
# Exercise 1 below is about finding the variance components!
# We can even assume that one of the main effects, operator, vanishes.
# Not carried out in the book
obj3 = aov(y ~ part, data=ex131)
gad(obj3)
M3 <- anova(obj3); M3
# We are back in the one-way ANOVA
n = 6
MSA = M3[1,3]; MSA
MSE = M3[2,3]; MSE
var.A = (MSA - MSE)/n; var.A
var.E = MSE; var.E
var.A + var.E
# Gives var.y = 11.14152

## Mixed model.  Montgomery, Example 13.3, p.585.  Same data as before
# Now the operators are treated as individuals, i.e. a fixed factor.
# The unrestricted model is used.
ex131$oper = as.fixed(ex131$oper)
obj4 = aov(y ~ oper*part, data=ex131)
gad(obj4)
# We could continue our analysis, but we will stop here.
# Cleaning up
rm(list=ls())


########################### EXERCISE #############################


# Exercise 1
# For the data in Example 13.1, do the calculations of the variance
# components in the model without interaction (the additive model) to
# get the estimates of the variance components on p.577. (Hint: Use
# obj2 from the demo.)


############################ PART 2 #############################


## Three-way ANOVA.  Montgomery, Example 5.3, p.208.
# y is fill height, A is percent carbonation, B is operating pressure,
# C is line speed
softdrink = read.table("softdrink.txt",header=TRUE)
softdrink
softdrink$A=as.factor(softdrink$A)
softdrink$B=as.factor(softdrink$B)
softdrink$C=as.factor(softdrink$C)
# We make the full model with all interactions
obj = aov(y ~ A*B*C,data=softdrink)
anova(obj)
# We now start a backwards elimination.  
# The effect with the highest p-value should be remove first.  
# However, A:B:C is a sub-partition of A:C and gets precedence.
anova(aov(y ~ (A + B + C)^2,data=softdrink))
anova(aov(y ~ A + B + C + A:B + B:C,data=softdrink))
# We stop with the model with A:B as the only interaction
obj2 = aov(y ~ A + B + C + A:B,data=softdrink); anova(obj2)
# We check the interaction plot
interaction.plot(softdrink$A, softdrink$B, softdrink$y, lty=1, col=c("red", "blue"))
# Almost parallel lines, but the standard error is small!
# Residual plots
res = resid(obj2)
yhat = fitted(obj2)
plot(yhat, res); abline(h=0, col="green")
stripchart(res ~ softdrink$A, method="stack", vert=T, pch=1); abline(h=0, col=3)
stripchart(res ~ softdrink$B, method="stack", vert=T, pch=1); abline(h=0, col=3)
stripchart(res ~ softdrink$C, method="stack", vert=T, pch=1); abline(h=0, col=3)

# Cleaning
rm(list=ls())


########################### EXERCISE #############################


# Exercise 2
# Problem 5.18 (pp.227)


############################# PART 3 ###############################


## A response surface.  Montgomery, Example 5.5, p.214
# Data: y is life time of cutting tool, A is cutting speed,
# B is tool angle
# We have a brief look at response surfaces and how to plot these
# in 3d - Chapter 11 contains a lot more on response surfaces.
toollife = read.table("toollife.txt",header=TRUE)
toollife
# We skip the part of Montgomery's example where he uses factors, 
# and just focus on the response surface. First short names:
y = toollife$y
a = toollife$A
b = toollife$B
reg = lm(y ~ (a + I(a^2))*(b + I(b^2)))
summary(reg)
c = coef(reg)
# We make the contour plot in Figure 5.19, p.217.
# We choose a grid with 21x21 points.
x = seq(15, 25, 0.5)
y = seq(125, 175, 2.5)
xg = matrix(rep(x, 21),21)
yg = matrix(rep(y, rep(21,21)),21)
z = c[1] + c[2]*xg + c[3]*xg^2 + c[4]*yg + c[5]*yg^2 +
  c[6]*xg*yg + c[7]*xg*yg^2 + c[8]*xg^2*yg + c[9]*xg^2*yg^2
contour(x, y, z)
# The levels are better than those in the book, but if we insist:
contour(x, y, z, levels=seq(-0.75, 4.75, 1.25))
# And a surface plot
persp(x, y, z, theta=-45, phi=30, r=10)
# Unfortunately this cannot be rotated with the mouse.
# For interactive 3d plotting we can use the package rgl.
library(rgl)
persp3d(x,y,z)
rgl.close()
# Many other plot types are available in this package
# And now that we are doing 3d plots, there is a 3d scatter plot
# in the package scatterplot3d:
library(scatterplot3d)
# The data
scatterplot3d(a,b,toollife$y)
# And a bit more fancy version
scatterplot3d(a,b,toollife$y,type="h",highlight.3d=TRUE,
              col.axis="blue",col.grid="lightblue",pch=20,zlab="y")
# Cleaning up
rm(list=ls())


############################## EXERCISE ############################


# Exercise 3
# Simulate an unbalanced two-way ANOVA with replicates. Here the
# function rnorm() can be used to simulate data that fits the
# assumptions of ANOVA. You can either let the means be equal or
# different. Try both a case with an unbalanced, but proportional
# design and a case with a non-proportional design. Compare the
# importance of the order of the variables in the two cases when you
# do an analysis of variance.

# Exercise 4
# Play around with some of the functions for plotting 3d: contour,
# persp, scatterplot3d or rgl.surface. There is also a function
# image() as alternative to contour and persp. The help-function can
# be useful in getting nice plots.
