##############################
#                            #
#        LECTURE FIVE        #
#                            #
##############################


############################# PART ONE ##############################


# Montgomery, Example 3.11, p. 119. The dataset contains strength
# measurements on the fabric produces by four looms.
ex311 = read.table("ex311.txt",header=TRUE)
ex311
class(ex311$y); class(ex311$loom)  
ex311$loom = as.factor(ex311$loom)

# In R, random factors are specified in Error()
# The command anova() does not work in models with Error()
obj = aov(y ~ Error(loom), data=ex311)
summary(obj)
# R does not calculate the p-values.
# The package GAD treats random and fixed factors more logically.
library(GAD)

# as.random() and as.fixed() makes random/fixed factors out of
# vectors (or factors)
ex311$loom = as.random(ex311$loom)
class(ex311$loom)
obj = aov(y ~ loom,data=ex311)
gad(obj)
# gad() should be used instead of anova() or summary() to treat 
# random/fixed factors correctly
# Note that in this case we get the same ANOVA table if we used
# fixed factors, but this will not be case for more advanced models.

# To get variance components we extract used values from the table
M = gad(obj); M
MSE = M[2,3]
MSA = M[1,3]
var.E = MSE; var.E            # Error component
var.A = (MSA - MSE)/4; var.A  # Loom component
var.y = var.E + var.A; var.y  # Total variance (estimated)

# Confidence interval for the error variance:
12*MSE/qchisq(c(0.975, 0.025), 12)
# Notice that it is asymmetric, i.e., var.E is not the midpoint

# Unfortunately, an exact confidence interval for the loom variance is
# impossible to make! Instead we make a confidence interval for its
# proportion of the total variance, estimated by
var.A/var.y
# 78.5% of the variation can be ascribed to different looms
# Confidence interval:
LU = 1/4*(MSA/MSE/qf(c(0.975, 0.025), 3, 12) - 1); LU
conf = LU/(LU + 1); conf
# Again, notice the asymmetry, var.A/var.y is not the midpoint

# Cleaning
rm(list=ls())


########################### EXERCISES ###########################


# Exercise 1:
# Problem 3.54 (p. 137)
# Skip (f).
# Bonus-question: If the fixed-factor ANOVA should instead be the
# appropriate tool for this data, what differences would that make
# for the experimental design and the conclusions?

########################### PART TWO ############################


# Data
graft = read.table("graft.txt",header=TRUE)

# Example 4.1, p.144 (with Block regarded as a random factor)
# Grafts (artificial veins) are manufactured, where the pressure used
# may influence the occurrence of defects. However, the materials come
# in batches that may contain variations, so this may also influence
# the occurrence of defects. The measurements y is the proportion of
# non-defect products.
graft
class(graft$y); class(graft$pressure); class(graft$batch)
graft$pressure = as.fixed(graft$pressure)
graft$batch = as.random(graft$batch)
obj = aov(y ~ pressure + batch, data=graft)
gad(obj)
# Shows that both batch and pressure are highly significant.
# The significance of batch is not considered in Montgomery,
# although he mentions the faulty analysis neglecting the batch
# affect, see Table 4-5: 
gad(aov(y ~ pressure, data=graft))  # Incorrect!

# Let's look at the variance components.
M = gad(obj)
MSE = M[3,3]; MSB = M[2,3]
var.E = MSE; var.E
var.B = (MSB - MSE)/4; var.B
# We see that they almost contribute equally.

# Cleaning
rm(list=ls())


########################## EXERCISES ##############################


# Exercise 2
# Problem 4.3 (p.177), considering "days" as random.
# Use Tukey's test to compare the washing solutions.
# (Hint: the function TukeyHSD will not work with as.fixed() or 
# as.random(), so only use as.factor() for this part of the exercise)


############################ PART THREE ###########################


# The R-package agricolae can create latin squares (and many other
# designs)
library(agricolae)
# four groups
design.lsd(LETTERS[1:4])
# easier to view as a matrix
matrix(design.lsd(LETTERS[1:4])[,4],4)
# five groups
matrix(design.lsd(LETTERS[1:5])[,4],5)
# This may help in making a correct latin square design.

# We look at Example 4.3 - rocket propellant is created with
# different formulas, operators and batches of material.
rocket = read.table("rocket.txt")

# A quick look at the data
rocket
# We ignore the variable assem - then this experiment has been
# designed as a latin square.
matrix(rocket$form,5)

# Checking classes
class(rocket$form); class(rocket$batch); class(rocket$oper)
rocket$batch = as.factor(rocket$batch);rocket$oper = as.factor(rocket$oper)

# We perform the analysis of variance with fixed factors
obj = aov(y~form+batch+oper,data=rocket)
summary(obj)

# We can now do residual plots, Tukey's test etc., but we will
# skip that
rm(list=ls())
