#############################
#                           #
#        LECTURE ONE        #
#                           #
#############################

# We will do all the calculations of this course in R, or more precisely RStudio.
# This is a list of all commands used for the first lecture.
# Notice that everything after # are comments.

############################## PART ONE #############################

### Simple things - we start with a few simple calculations
# In Rstudio you can run a or selection of lines by pressing CTRL+ENTER

7*17
1/9
sqrt(2)
2^10
pi

# We can get pi with more digits

options(digits=20)
pi
1/9

# We notice that "only" around 16 significant digits are shown,
# corresponding to double precision.  All calculations are with this
# precision, also when not all the digits are shown. From now we use:

options(digits=5)

### Assignment
# There are several ways to assign a value to a variable

a <- 7      # The original way
b = 13      # Also used now
1.234 -> c  # Could be useful
a; b; c     # Note that ; separates multiple commands on the same line

# We list the assigned variables and then delete them

ls()
rm(a, b, c)
ls()

# The command 'rm(list=ls())' removes all variables!

### Getting help

?ls           # Opens help for the ls() command
help.start()  # Opens a help page for R
?options      # Parameters for the setup
?par          # Parameters for graphics

### A simple plot

x = c(1.1, 4.9, 1.8, 3.0, 4.2, 1.1)

# The command 'c' concatenates a vector. I'll show an alternative way
# to key in data, simple with small datasets. (For large
# datasets, reading from a file should be used!)

y = scan()
#1: 3.6 3.6 1.4 5.0 1.4 3.6 7.1
#8:
#Read 7 items

# The automatic number in front keeps record of number of entered
# entries, finish with a blank line.

plot(x,y)
length(x); length(y)

# This didn't work, and we see why: The vectors have different length.
# We remove the last entry:

y[7]        # just checking what it is
y = y[-7]   # removing
plot(x, y)

# We'll make more of this plot.

plot(x, y, type="b", pch=16, lwd=2, col="blue")

### A matrix equation

A = matrix(1:9, ncol=3, nrow=3)
A

# Reading the elements row-wise: matrix(1:9, ncol=3, nrow=3, byrow=TRUE)

x = 1:3
A * x    # Warning! This is not the matrix product
A %*% x  # x is automatically converted to a column vector
b = .Last.value  # .Last.value stores the result of the last calculation
b
# Can x be recovered form the matrix equation Ax = b ?

solve(A, b)

# No. A is a singular matrix. This can be remedied

A[3,3] = 8
b = A %*% x ; b  
solve(A, b)

# How is the inverse matrix found ?

A^(-1)   # Wrong!  Works element-wise
B <- solve(A) ; B
A %*% B  # Gives the identity matrix. With a nicer look here:
round(A %*% B, 7) 
B %*% b

# Finishes for now - we clean up
rm(list=ls())

# If we wanted to quit, we could use the command: q()


######################### EXERCISES ##############################


# Problem 1
#
# Solve the equation system
#
#    x - 2y +  z =  0
#        2y - 8z =  8
#  -4x + 5y + 9z = -9

# Problem 2
#
# The nxn Hilbert matrix has as its (i,j)th element 1/(i+j-1).
# It can be shown that the inverse matrix has integer elements.
# It is invertible but close to being singular.
# Therefore it is very sensitive to numerical errors.
# Compute the inverses of
#
#         [  1   1/2 ]            [ 1.00  0.50 ]
#   H_2 = [          ] ,   H*_2 = [            ]
#         [ 1/2  1/3 ]            [ 0.50  0.33 ]
#
# Make experiments with bigger Hilbert matrices.
# How can they be constructed in a simple way?


############################### PART TWO #############################

### Reading and plotting a dataset

# We do some preliminary operations on the dataset in Table 2-1, p.26.
# We start by using a file, mortar.txt, with the data

 16.85 16.62
 16.40 16.75
 17.21 17.37
 16.35 17.12
 16.52 16.98
 17.04 16.87
 16.96 17.34
 17.15 17.02
 16.59 17.08
 16.57 17.27

# These values are saved in the file mortar.txt
# One way of reading a file is scan()

y = scan("mortar.txt")

# Note that you should use a path if the data is not in your working directory, fx
# scan("~/teaching/DAE/design13/lec01/mortar.txt")
# Notice the forward slashes - this is even used in windows.

# scan() saves all numbers in a vector
y
# Not the ideal format; modified and unmodified values alternate!

# Let us use a matrix to get it right

M = matrix(y, nrow=10, ncol=2, byrow=TRUE); M
y1 = M[,1]; y1
y2 = M[,2]; y2

# We check the averages shown in Figure 2.1

mean(y1); mean(y2)

# Now we make the dot diagram in Figure 2.1. First an empty plot

plot(x=range(c(y1, y2)), y = c(0,1), xlab="Strength", ylab="", type="n")
points(y2, rep(0.3, 10), pch=16)
points(y1, rep(0.7, 10), pch=16)

# And now Figure 2.3 (p. 28)

boxplot(y1, y2)
boxplot(y1, y2, boxwex=0.4, col="gray")
axis(1, at=c(1,2), labels=c("Modified", "Unmodified"))

# No more about this dataset today - we'll return to it the next time

### The normal distribution

# We simulate a normal distribution and make a normal
# probability plot. We generate 50 values from N(5, 2^2).

y = rnorm(50, 5, 2); y
hist(y, freq=FALSE)

# We insert the normal density by using 'curve'. The argument to the
# function MUST be 'x'.

curve(dnorm(x, 5, 2), col="red", add=TRUE)

# And then the normal probability plot:

qqnorm(y, datax=TRUE)
qqline(y, datax=TRUE)

# We find the calculated mean and standard deviation

mean(y); sd(y)

# note that we have the following commands for the normal distribution
m = 1; sd = 3
dnorm(3,m,sd) # calculate density at x=3
pnorm(2,m,sd) # calculate distribution function at x=2
qnorm(0.8,m,sd) # calculate quantile at p=0.8
rnorm(3,m,sd) # generate 3 random numbers

# similar functions exist for other distributions, i.e. for * = d,p,q,r
# *chisq, *t, *f, or many other distributions

# central limit theorem - non-normally (independent) distributed 
# numbers become increasingly normal when added together
x = rep(0,1000)
par(mfrow=c(2,2))
for (i in 1:1000) x[i]=runif(1,0,1) # uniform numbers
hist(x)
for (i in 1:1000) x[i]=sum(runif(2,0,1)) # sum of 2 uniform numbers
hist(x)
for (i in 1:1000) x[i]=sum(runif(5,0,1)) # sum of 5 uniform numbers
hist(x)
for (i in 1:1000) x[i]=sum(runif(10,0,1)) # sum of 10 uniform numbers
hist(x)
par(mfrow=c(1,1))

# Cleaning up
rm(list=ls())

# Problem 3
#
# Make a vector y with 20 elements:
#
# 41 57 74 49 55 57 26 56 27 42
# 68 56 46 54 42 67 57 61 61 46
#
# Find mean, median, variance, standard deviation and range
# Make a boxplot and a histogram
# Make a QQ-plot - do the numbers look normally distributed?
#

# Problem 4

# Simulate a non-normal distribution (fx chi-square, t or F).
# Using histograms and QQ-plots, test if you can see a deviation 
# from normality. Use both small and large samples.

# If you finish this, you can try to figure out
# how to use the functions *chisq, *t, *f where * = d,p,q
# for calculating probabilities in chi-squared, t and F distributions.
